#include <cstdio>
#include <hal/drivers/flash.h>
#include <hal/devices.h>

int cmd_cellconstant(int argc, char *argv[])
{
	if (argc != 2)
	{
		printf("%s: error, syntax: ADDRESS %s CELL_CONSTANT\n\n", argv[0], argv[0]);
	}
	else
	{
		float constant = -1;
		sscanf(argv[1], "%f", &constant);

		if (constant <= configure_file.max_cell_const && constant >= configure_file.min_cell_const)
		{
			flash_file * p_flash_file;

			decltype(p_flash_file->cell_const) cell_const = constant;

			fseek(p_flash, (int) (&p_flash_file->cell_const) - (int) (p_flash_file), SEEK_SET);
			fwrite(&cell_const, sizeof(flash_file::cell_const), 1, p_flash);
			fflush(p_flash);

			printf("%s: the cell constant is set to: %f/cm\n\n", argv[0], constant);
		}
		else
		{
			printf("%s: error, cell constant input: %s is not in range: %f~%f\n\n", argv[0], argv[1],
			    configure_file.min_cell_const, configure_file.max_cell_const);
		}
	}

	fflush(stdout);
}
